// controllers/qrLoginController.js
const { User, Website_Setting, LinkedDevices } = require("../../models");
const { generateToken, saveToken, confirmToken, getTokenStatus } = require("./store");

const jwt = require("jsonwebtoken");
let jwtSecretKey = process.env.JWT_SECRET_KEY;
  
  // 1. Generate QR token
  exports.initLogin = (req, res) => {
    const token = generateToken();
    saveToken(token);
    res.json({ token });
  };
  
  // 2. Confirm token (scanned from Flutter)
  exports.confirmLogin = (req, res) => {
    const { token, userId } = req.body;
    const success = confirmToken(token, userId);
    if (success) {
      res.status(200).json({ success: true, message: "Token confirmed" });
    } else {
      res.status(400).json({ success: false, error: "Invalid token" });
    }
  };
  
  // 3. Check login status (web polls)
  exports.checkStatus = (req, res) => {
    const token = req.body.token;
    const status = getTokenStatus(token);
    if (!status) {
      return res.status(404).json({ error: "Token not found" });
    }
    res.json(status);
  };

  exports.initqrLogin = async (req, res) => {
    let { user_id, device_token, device_type, device_name, device_model, device_os, one_signal_player_id } = req.body;

    try {
        const resData = await User.findOne({
          where: { user_id: user_id },
        });
        // console.log("newResData", newResData);
        // console.log(resData);
        if (resData) {
          // console.log(newResData);
          const token = jwt.sign(resData.dataValues, jwtSecretKey);
    
          // Update Device Token ==================================================================
          User.update(
            { device_token, one_signal_player_id },
            {
              where: { user_id: user_id },
            }
          );
    
          // Update Linked Devices ==================================================================
          LinkedDevices.create({
            user_id: user_id,
            device_token: device_token,
            device_type: device_type,
            device_name: device_name,
            device_model: device_model,
            device_os: device_os,
          });

          res.status(200).json({
            message: "QR Login Success",
            success: true,
            token: token,
            resData: resData,
            // is_require_filled,
          });
        } else {
          res.status(200).json({ message: "Invalid otp!", success: false });
        }
      } catch (error) {
        // Handle the Sequelize error and send it as a response to the client
        res.status(500).json({ success: false, error: error.message });
      }
  };
  