// store.js

const tokens = new Map(); // token => { userId, confirmed }

function generateToken() {
  return "loginwithmyapp" + Math.random().toString(36).substring(2, 12); // simple 12-char token first 4 char is user id is loginwithmyapp this frist after randem 12 char
}

function saveToken(token) {
  tokens.set(token, { confirmed: false, userId: null });
}

function confirmToken(token, userId) {
  if (!tokens.has(token)) return false;

  tokens.set(token, { confirmed: true, userId });
  return true;
}

function getTokenStatus(token) {
  return tokens.get(token); // returns { confirmed: true/false, userId }
}

module.exports = {
  generateToken,
  saveToken,
  confirmToken,
  getTokenStatus,
};
