module.exports = (sequelize, DataTypes) => {
    const LinkedDevices = sequelize.define("LinkedDevices", {
        id: {
            type: DataTypes.INTEGER,
            primaryKey: true,
            autoIncrement: true,
        },
        user_id: {
            type: DataTypes.INTEGER,
            allowNull: true,
        },
        device_id: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        device_type: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        device_token: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        device_name: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        device_model: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        device_os: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        device_last_time: {
            type: DataTypes.STRING,
            allowNull: true,
        },
    });


    LinkedDevices.associate = function(models) {
        LinkedDevices.belongsTo(models.User, {
            foreignKey: "user_id",
            as: "User",
        });
    };

    return LinkedDevices;
};

